varying vec2 p_textureCoord;

varying vec4 p_color;
uniform sampler2D base_texture;
uniform vec3 p_ambient_color;
uniform vec3 p_enviro_color;
uniform float p_enviro_fraction;

void main()
{
    lowp vec4 resultColor = texture2D(base_texture, p_textureCoord) * p_color;
    resultColor.xyz += p_enviro_fraction * p_enviro_color * resultColor.xyz;
    resultColor.xyz += p_ambient_color * resultColor.a;
    gl_FragColor = resultColor;
}
